package com.cmeeting.controller;

import com.cmeeting.util.R;
import com.cmeeting.util.RedisUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Map;


@RestController
@RequestMapping("/email")
public class EmailController {

    @Resource
    private RedisUtils redisUtils;

    @PostMapping("/saveContentTemplate")
    public R saveContentTemplate(@RequestBody Map<String,Object> map){
        if(!map.containsKey("template")){
            return R.error("保存失败");
        }
        redisUtils.set("EMAIL_CONTENT_TEMPLATE",map.get("template"));
        return R.ok("保存成功");
    }

    @GetMapping("/getContentTemplate")
    public R getTemplate(){
        if(!redisUtils.hasKey("EMAIL_CONTENT_TEMPLATE")){
            return R.error("邮件通知内容未设置");
        }
        return R.ok(redisUtils.get("EMAIL_CONTENT_TEMPLATE"));
    }
}
