package com.cmeeting.constant;

/**
 * 会议处理状态枚举类
 */
public enum MeetingState {
    /**
     * 会议状态枚举类型
     */
    // 新会议待处理
    NEW(0, "新会议待处理"),
    // 处理中
    GENERATE_ERROR(1, "生成纪要失败"),
    // 生成纪要成功
    NOTE_GENERATED(2, "生成纪要成功"),
    // 推送纪要成功
    PUSH_SUCCESS(3, "推送纪要邮件成功"),
    PUSH_ERROR(4, "推送纪要邮件失败"),
    EMPTY(5, "转录文件为空")
    ;

    // 状态码
    private final int code;
    // 状态描述
    private final String description;

    /**
     * 枚举构造方法
     * @param code 状态码
     * @param description 状态描述
     */
    private MeetingState(int code, String description) {
        this.code = code;
        this.description = description;
    }

    // 获取状态码
    public int getCode() {
        return code;
    }

    // 获取状态描述
    public String getDescription() {
        return description;
    }

    /**
     * 根据状态码获取状态枚举值
     * @param code 状态码
     * @return 对应的枚举值，若不存在则返回null
     */
    public static MeetingState fromCode(int code) {
        for (MeetingState state : values()) {
            if (state.code == code) {
                return state;
            }
        }
        return null;
    }

    /**
     * 扩展方法示例：获取状态类型描述
     * @return 返回状态类型描述
     */
    public String getTypeDescription() {
        return "会议处理状态";
    }
}