package com.cmeeting.ad.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 登录
 */
@Data
public class UserVo {

    /**
     * 登录
     */
    @Data
    public static class Login {
        String username;

        String password;
        String key;
    }

    @Data
    public static class officialSiteLogin {
        String username;

        String password;
    }

    @Data
    public static class LoginDecrypt {
        String data;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class Auth {
        /**
         * 用户id （系统和应用用户的主键id，同步用户的userId）
         */
        private String id;
        private String tenantId;
        /**
         * 用户类型：0. 系统用户  1. 应用用户  2. 同步用户
         */
        private Integer type;

        private String username;

        private String nick;

        private String path;

        private long expireDate;
    }

    /**
     * 更新昵称和头像
     */
    @Data
    public static class UpdateNick {
        private String nick;
        private String picture;
    }

    /**
     * 更新密码
     */
    @Data
    public static class UpdatePassword {
        private String password;
        private String newPassword;
        private String repeatPassword;
    }
}
