package com.cmeeting.ad.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.cmeeting.ad.entity.*;
import com.cmeeting.ad.service.ILdapService;
import com.cmeeting.ad.service.ISysTenantService;
import com.cmeeting.ad.service.UserService;
import com.cmeeting.ad.util.JwtUtil;
import com.cmeeting.ad.util.SecurityUtil;
import com.cmeeting.ad.vo.ApplicationUserVO;
import com.cmeeting.ad.vo.UserVo;
import com.cmeeting.constant.CategoryConstant;
import com.cmeeting.constant.UserAdminRouteConstant;
import com.cmeeting.exception.RobotBaseException;
import com.cmeeting.mapper.primary.AuthMapper;
import com.cmeeting.mapper.primary.CommonMapper;
import com.cmeeting.mapper.secondary.SysUserSysMapper;
import com.cmeeting.pojo.CoreModulePermissions;
import com.cmeeting.util.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.*;
import java.util.stream.Collectors;

@Service
@Slf4j
public class UserServiceImpl implements UserService {

    @Value("${aec.key}")
    public String aesKey;
    @Value("${permission.applicationId}")
    public String applicationId;
    @Value("${removeMenus}")
    private String removeMenus;
    @Value("${jwt.expireTime}")
    private String expireTime;
    @Value("${permission.tenantId}")
    public String permissionTenantId;
    @Value("${permission.admin-white_users}")
    public String adminWhiteUsers;
    @Value(value = "${permission.applicationId}")
    private String permissionApplicationId;
    @Resource
    private ILdapService iLdapService;
    @Resource
    private UserAdminConfig userAdminConfig;
    @Resource
    private AuthenticationManager authenticationManager;
    @Resource
    private RedisUtils redisUtils;
    @Resource
    private ISysTenantService iTenantService;
    @Resource
    private JwtUtil jwtUtil;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private SysUserSysMapper sysUserSysMapper;
    @Resource
    private AuthMapper authMapper;
    @Resource
    private SysUserSysMapper sysUserSyncMapper;

    @Override
    public R login(String agentId, String data, String ip) {
        String mess = AESUtils.decrypt(data, aesKey);
        ApplicationUserVO.Login login = JSONObject.parseObject(mess, ApplicationUserVO.Login.class);
        log.info("登录信息：{}", login);
        return loginByAD(login);
    }

    @Override
    public String auth(String userId, String nick) {
        HashMap<String, String> stringStringHashMap = new HashMap<>();
        SysTenant sysTenant = iTenantService.getById(permissionTenantId);
        stringStringHashMap.put("userId", userId);
        stringStringHashMap.put("tenantId", permissionTenantId);
        stringStringHashMap.put("language", sysTenant.getLanguage());
//        iUserLoginInfoService.updateInfo(null, userId, tenantId, null);
        stringStringHashMap.put("nick", nick);
        UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken(userId, permissionTenantId);
        usernamePasswordAuthenticationToken.setDetails(stringStringHashMap);
        Authentication authentication = authenticationManager.authenticate(usernamePasswordAuthenticationToken);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        RobotSecurityUser userDetail = (RobotSecurityUser) authentication.getPrincipal();
        System.out.println(userId.toString());
        String token = jwtUtil.generateToken(userDetail);
        List<SysMenu> menuList = commonMapper.getMenuList(permissionTenantId);
        // 需要对menuList进行过滤
        // 根据uid查询对应角色，然后查询角色对应的菜单权限
//        List<String> roleIdList = getRoleIdByUserId(permissionTenantId, userId, path);
//        List<SysMenu> menuList1 = CollectionUtils.isEmpty(roleIdList) ? new ArrayList<>() : commonMapper.getMenuByRoleList(roleIdList, permissionTenantId);
//        Set<Integer> menuSet = menuList1.stream().map(SysMenu::getId).collect(Collectors.toSet());
//        List<SysMenu> filteredMenu = menuList.stream().filter(menu -> menuSet.contains(menu.getId())).collect(Collectors.toList());
//        menuList = (List<SysMenu>) CollectionUtils.intersection(filteredMenu, menuList);
        menuList.sort(Comparator.comparingInt(SysMenu::getSort));

        // 总库去掉部分菜单
        if ("system".equals(userDetail.getUsername())) {
            List<String> removeMenuList = Arrays.asList(removeMenus.split(","));
            int size = menuList.size();
            for (int i = 0; i < size; i++) {
                SysMenu sysMenu = menuList.get(i);
                String tempName = sysMenu.getName();
                if (removeMenuList.contains(tempName)) {
                    menuList.remove(sysMenu);
                    size -= 1;
                    i -= 1;
                }
            }
        }
        RoleTree loginMenus = getLoginMenus(menuList);
        HashSet<String> set = new HashSet<>();
        for (SysMenu sysMenu : menuList) {
            set.add(sysMenu.getPerms());
        }
        if (set.contains("interactCenter")) {
            //看是否勾选了首页配置 121是首页菜单的id
            loginMenus.getInteractCenter().add("modelList");
            loginMenus.getInteractCenter().add("modelPage");
        }
        if (set.contains("robotCenter")) {
            //看是否勾选了首页配置 121是首页菜单的id
            loginMenus.getRobotCenter().add("robotPage");
        }
        if (set.contains("processCenter")) {
            //看是否勾选了首页配置 121是首页菜单的id
            loginMenus.getProcessCenter().add("processPage");
        }
        userDetail.setMenus(loginMenus);
//        SysPlatformSetting platformInfo = relPlatformSettingService.getPlatformInfoByCurrentTenantId(userDetail.getTenantId());
//        SysPlatformSetting newSysPlatformSetting = new SysPlatformSetting();
//        BeanUtil.copyProperties(platformInfo, newSysPlatformSetting);
//        newSysPlatformSetting.setDocKnowledge(0);
//        userDetail.setSysPlatformSetting(newSysPlatformSetting);

        redisUtils.set(token, userDetail, Long.parseLong(expireTime));
        return token;
    }

    @Override
    public List<String> getRoleIdByUserId(String tenantId, String userId, String path) {
        List<ModulePermissions> permissions = commonMapper.getRoleByTenantId(tenantId);
        Map<String, List<ModulePermissions>> userMap = permissions.stream().filter(per -> per.getType() == 1).collect(Collectors.groupingBy(ModulePermissions::getRelId));
        Map<String, List<ModulePermissions>> deptMap = permissions.stream().filter(per -> per.getType() == 0).collect(Collectors.groupingBy(ModulePermissions::getRelId));
        List<String> roleList = new ArrayList<>();
        if (userMap.containsKey(userId)) {
            List<ModulePermissions> tempPers = userMap.get(userId);
            for (ModulePermissions tempPer : tempPers) {
                roleList.add(tempPer.getTargetId());
            }
        }
        if (path == null && tenantId.equals("1")) {
            List<String> admin = new ArrayList<>();
            admin.add("1");
            return admin;
        }
        if (StrUtil.isNotBlank(path)) {
            String[] split = path.split(CategoryConstant.ROOT_PATH);
            List<String> deptList = Arrays.asList(split).stream().filter(StrUtil::isNotBlank).collect(Collectors.toList());
            for (String dept : deptList) {
                if (deptMap.containsKey(dept)) {
                    List<ModulePermissions> tempPers = deptMap.get(dept);
                    for (ModulePermissions tempPer : tempPers) {
                        roleList.add(tempPer.getTargetId());
                    }
                }
            }
        }
        return roleList;
    }

    @Override
    public RoleTree getLoginMenus(List<SysMenu> menuList) {
        RoleTree roleTree = new RoleTree();
        if (CollUtil.isEmpty(menuList)) {
            return roleTree;
        }
        menuList.forEach(it -> {
            if (it.getParentId() != 0 && StrUtil.isNotBlank(it.getPath())) {
                if (it.getParentSystem().contains("tenantCenter")) {
                    roleTree.getTenantCenter().add(it.getPerms());
                } else if (it.getParentSystem().contains("interactCenter")) {
                    roleTree.getInteractCenter().add(it.getPerms());
                } else if (it.getParentSystem().contains("knowledgeCenter")) {
                    roleTree.getKnowledgeCenter().add(it.getPerms());
                } else if (it.getParentSystem().contains("llmCenter")) {
                    roleTree.getLlmCenter().add(it.getPerms());
                } else if (it.getParentSystem().contains("statisticsCenter")) {
                    roleTree.getStatisticsCenter().add(it.getPerms());
                } else if (it.getParentSystem().contains("securityCenter")) {
                    roleTree.getSecurityCenter().add(it.getPerms());
                } else if (it.getParentSystem().contains("robotCenter")) {
                    roleTree.getRobotCenter().add(it.getPerms());
                } else if (it.getParentSystem().contains("staffCenter")) {
                    roleTree.getStaffCenter().add(it.getPerms());
                }else if (it.getParentSystem().contains("processCenter")) {
                    roleTree.getProcessCenter().add(it.getPerms());
                }
            }
        });
        return roleTree;
    }

    @Override
    public Object list(String search, Integer type, Integer userType, String categoryId, Integer authType) {
        String url = userAdminConfig.getUserAdminDomain() + UserAdminRouteConstant.SysUser.FIND_NAME;
        JSONObject body = new JSONObject();
        body.put("tenantId", SecurityUtil.getTenantId());
        body.put("type", userType);
        body.put("categoryId", categoryId);
        body.put("search", search);
        // 模糊查询
        body.put("searchType", 1);
//                + "?search=" + UrlEncoderUtil.encode(search.trim())
//                + "&type=" + type
//                + "&userType=2"
//                + "&categoryId=" + categoryId
//                + "&targetId=" + targetId;
        System.out.println(url);
        JSONObject object = HttpClientUtils.httpPost(url,body, UserAdminTokenUtil.getUserAdminToken());
        return object;
    }

    @Override
    public Object tokenAuth(ApplicationUserVO.LoginDecrypt vo) {
        String aigcToken = vo.getData();
        String url = userAdminConfig.getSystemDomain() + "/cloud/info";
        JSONObject object = HttpClientUtils.httpGet(url, aigcToken);
        if("0".equals(object.get("code"))){
            return null;
        }
        JSONObject data = object.getJSONObject("data");
        RobotSecurityUser robotSecurityUser = JSON.parseObject(data.toJSONString(), RobotSecurityUser.class);
        String userId = String.format("%08d", robotSecurityUser.getUserId());

        //权限控制
        List<CoreModulePermissions> auths = authMapper.getAuthByTargetId(permissionApplicationId, permissionTenantId);
        //先判断智能体是否有直接授权给当前登录人
        boolean userAccess = auths.stream().anyMatch(item -> item.getType().equals(1) && item.getRelId().equals(userId));
        //未直接授权到人，判断是否有授权给当前登录人所在组织
        if(!userAccess){
            List<CoreModulePermissions> authDepts = auths.stream().filter(item -> item.getType().equals(0)).collect(Collectors.toList());
            List<String> deptPath = new ArrayList<>();
            for (CoreModulePermissions authDept : authDepts) {
                String deptId = authDept.getRelId();
                String tenantId = authDept.getTenantId();
                getDeptPath(deptPath,deptId,tenantId);
            }
            //已被授权部门下的userid
            List<String> accessUserIds = !CollectionUtils.isEmpty(deptPath) ? sysUserSyncMapper.getUsersByDept(deptPath,permissionTenantId) : new ArrayList<>();
            if(!accessUserIds.contains(userId)){
                throw new RobotBaseException("您暂无权限");
            }
        }

        return auth(userId, robotSecurityUser.getNickName());
    }

    @Override
    public String emailAuth(UserVo.Auth vo) {
        String userId = vo.getId();
        String nick = vo.getNick();
        //时间戳
        long expireDateTimestamp = vo.getExpireDate();
        ZonedDateTime expireDate = Instant.ofEpochMilli(expireDateTimestamp).atZone(ZoneId.systemDefault());
        ZonedDateTime now = ZonedDateTime.now();
        //todo 暂时将链接设为长期有效，后续根据业务情况调整（原因是链接如果过期，普通用户没有可以跳转的登录界面，目前的管理端登录界面只能黄飞用）
//        if(expireDate.isBefore(now)){
//            throw new RobotBaseException("认证已过期！", 401);
//        }
        long expireTimeStamp = Duration.between(now, expireDate).getSeconds();
        HashMap<String, String> stringStringHashMap = new HashMap<>();
        SysTenant sysTenant = iTenantService.getById(permissionTenantId);
        stringStringHashMap.put("userId", userId);
        stringStringHashMap.put("tenantId", permissionTenantId);
        stringStringHashMap.put("language", sysTenant.getLanguage());
        stringStringHashMap.put("nick", nick);
        UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken(userId, permissionTenantId);
        usernamePasswordAuthenticationToken.setDetails(stringStringHashMap);
        Authentication authentication = authenticationManager.authenticate(usernamePasswordAuthenticationToken);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        RobotSecurityUser userDetail = (RobotSecurityUser) authentication.getPrincipal();
        String token = jwtUtil.generateToken(userDetail);
        redisUtils.set(token, userDetail, expireTimeStamp);
        return token;
    }

    private R loginByAD(ApplicationUserVO.Login login) {
        // AD验证
        String username = login.getUsername().trim();
        boolean auth = iLdapService.authenticate(username, login.getPassword().trim());
        if (auth) {
//        if(true){
            SysUserSync sysUserSync = sysUserSysMapper.selectOne(new LambdaQueryWrapper<SysUserSync>()
                    .eq(SysUserSync::getTenantId, permissionTenantId)
                    .eq(SysUserSync::getUserId, username));
            if(StringUtils.isEmpty(adminWhiteUsers) || !Arrays.asList(adminWhiteUsers.split(",")).contains(username)){
                throw new RobotBaseException("尊敬的用户 ["+sysUserSync.getName()+"]，您的账户"+username+"未被授权访问此系统，请联系系统管理员。");
            }
            return R.ok(auth(sysUserSync.getUserId(), sysUserSync.getName()));
        } else {
            return R.error("账号/密码错误！");
        }
    }

    /**
     * 获取部门的路径
     * @param deptPath
     * @param deptId
     * @param tenantId
     */
    private void getDeptPath(List<String> deptPath, String deptId, String tenantId) {
        if(!deptPath.contains(deptId)) deptPath.add(deptId);
        List<String> subDeptIds = sysUserSyncMapper.getSubDeptId(deptId,tenantId);
        if(CollectionUtils.isEmpty(subDeptIds)) return;

        for (String subDeptId : subDeptIds) {
            //部门id去重
            if(!deptPath.contains(subDeptId)){
                deptPath.add(subDeptId);
                getDeptPath(deptPath,subDeptId,tenantId);
            }
        }

    }
}