package com.cmeeting;

import com.alibaba.fastjson2.JSON;
import com.cmeeting.email.EmailSender;
import com.cmeeting.mapper.primary.AuthMapper;
import com.cmeeting.mapper.primary.UserIdMapper;
import com.cmeeting.mapper.secondary.SysUserMapper;
import com.cmeeting.mapper.secondary.SysUserSysMapper;
import com.cmeeting.pojo.CoreModulePermissions;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.tencentcloudapi.wemeet.Client;
import com.tencentcloudapi.wemeet.core.authenticator.AuthenticatorBuilder;
import com.tencentcloudapi.wemeet.core.authenticator.JWTAuthenticator;
import com.tencentcloudapi.wemeet.core.exception.ClientException;
import com.tencentcloudapi.wemeet.core.exception.ServiceException;
import com.tencentcloudapi.wemeet.core.xhttp.ApiResponse;
import com.tencentcloudapi.wemeet.service.meeting_control.api.MeetingControlApi;
import com.tencentcloudapi.wemeet.service.meeting_control.model.V1RealControlMeetingsMeetingIdAsrPutRequest;
import com.tencentcloudapi.wemeet.service.meetings.api.MeetingsApi;
import com.util.meeting.MeetingMinutesGenerator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.ResponseEntity;
import org.springframework.http.HttpStatus;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.*;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.stream.Collectors;

@RestController
@RequestMapping
public class TencentMeetingCallbackController {
    private static final Logger logger = LoggerFactory.getLogger(TencentMeetingCallbackController.class);
    /**
     * *
     * * 配置参数 - 从配置文件或环境变量获取
     * * 用于校验腾讯会议的事件订阅
     */


    //tencent.meeting.token
    private final String token = "Jo6X4sZKhPFknSdBH8o6gXVOb";
    //tencent.meeting.aesKey
    private final String encodingAESKey = "AhES8VLIoktG4KGPqgKz6uUMtvs67JZWCuStmogMAwr";

    // 1.构造 client 客户端(jwt 鉴权需要配置 appId sdkId secretID 和 secretKey)
    Client client = new Client.Builder()
            .withAppId("211153201").withSdkId("28370276340")
            .withSecret("BKOMDZVbvh0iT7k6UHsSizAWBCOVDtT6", "3Y1j0mzNp7KChKFJGyaEnZHLobFoAQ8eLwfaMx8nLbtXAerO")
            .build();
    @Autowired
    private UserIdMapper userIdMapper;
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private AuthMapper authMapper;
    @Autowired
    private SysUserSysMapper sysUserSysMapper;

    //处理GET请求 - URL验证
    @GetMapping
    public ResponseEntity<String> verifyUrl(
            @RequestParam("check_str") String checkStr,
            @RequestHeader("timestamp") String timestamp,
            @RequestHeader("nonce") String nonce,
            @RequestHeader("signature") String signature) {

        try {
            // 1. URL解码
            checkStr = URLDecoder.decode(checkStr, StandardCharsets.UTF_8.name());

            // 2. 验证签名
            if (!verifySignature(token, timestamp, nonce, checkStr, signature)) {
                return ResponseEntity.status(HttpStatus.FORBIDDEN).body("Signature verification failed");
            }

            // 3. 解密check_str
            String decryptedStr = decryptData(checkStr);

            // 4. 返回明文(不能加引号或换行符)
            return ResponseEntity.ok(decryptedStr);

        } catch (Exception e) {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR)
                    .body("Error: " + e.getMessage());
        }
    }

    //处理POST请求 -事件回调
    @PostMapping(consumes = "application/json")

    public ResponseEntity<String> handleEvent(
            @RequestBody Map<String, String> requestBody,
            @RequestHeader("timestamp") String timestamp,
            @RequestHeader("nonce") String nonce,
            @RequestHeader("signature") String signature) {

        try {
            // 1. 获取data字段
            String encryptedData = requestBody.get("data");
            if (encryptedData == null) {
                return ResponseEntity.badRequest().body("Missing data field");
            }

            // 2. 验证签名
            if (!verifySignature(token, timestamp, nonce, encryptedData, signature)) {
                return ResponseEntity.status(HttpStatus.FORBIDDEN).body("Signature verification failed");
            }

            // 3. 解密data
            String decryptedData = decryptData(encryptedData);
            logger.info("Decrypted event data: {}", decryptedData);
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode rootNode = objectMapper.readTree(decryptedData);
                JsonNode firstPayload = rootNode.path("payload").get(0);
                String userId = firstPayload.path("operator").path("userid").asText();
                // 通过腾讯的userid查询到企业微信的userid
                String wid = userIdMapper.getWidByTid(userId);
                logger.info("该用户的工号id：{}，", wid);
                // 调用admin的find接口查询用户信息包括用户的部门id路径
                String userDeptPath = sysUserMapper.getUserDeptPath(wid);
                logger.info("该用户的部门路径：{}，", userDeptPath);
                List<String> deptPath = null;
                if (userDeptPath != null && !userDeptPath.isEmpty()) {
                    // 使用split方法分割字符串，并过滤掉空字符串
                    deptPath = Arrays.stream(userDeptPath.split("/"))
                            .filter(s -> !s.isEmpty())
                            .collect(Collectors.toList());
                }
                logger.info("分割后的部门路径列表：{}", deptPath);
                //通过智能体id查询该id下的部门和用户
                String targetId = "1815393211829587968";//职能体id
                String tenantId = "1806976109082972160";//租户id
                List<CoreModulePermissions> auths = authMapper.getAuthByTargetId(targetId, tenantId);
                // 创建两个集合分别存储type=0(部门)和type=1（员工）的数据
                List<CoreModulePermissions> type0List = new ArrayList<>();
                List<CoreModulePermissions> type1List = new ArrayList<>();

                for (CoreModulePermissions auth : auths) {
                    if (auth.getType() == 0) {
                        type0List.add(auth);
                    } else if (auth.getType() == 1) {
                        type1List.add(auth);
                    }
                    // 如果type为null或其他值，这里会被忽略
                }
                // 检查权限
                boolean hasPermission = false;
                // 1. 先检查员工是否在type1List中
                for (CoreModulePermissions empAuth : type1List) {
                    if (wid.equals(empAuth.getRelId())) {
                        hasPermission = true;
                        logger.info("员工{}在直接授权列表中", wid);
                        break;
                    }
                }
                // 2. 如果员工不在直接授权列表中，检查部门权限
                if (!hasPermission && !deptPath.isEmpty()) {
                    for (CoreModulePermissions deptAuth : type0List) {
                        if (deptPath.contains(deptAuth.getRelId())) {
                            hasPermission = true;
                            logger.info("员工{}通过部门{}获得权限", wid, deptAuth.getRelId());
                            break;
                        }
                    }
                }
                if (hasPermission) {
                    processEvent(decryptedData);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            // 5. 返回成功响应(必须严格匹配)
            return ResponseEntity.ok("successfully received callback");
        } catch (Exception e) {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR)
                    .body("Error: " + e.getMessage());
        }
    }


    //验证签名(SHA1)


    private boolean verifySignature(String token, String timestamp, String nonce,
                                    String data, String receivedSignature) throws Exception {
        // 1. 按字典序排序
        String[] arr = new String[]{token, timestamp, nonce, data};
        Arrays.sort(arr);

        // 2. 拼接字符串
        String combined = String.join("", arr);

        // 3. SHA1加密
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] digest = md.digest(combined.getBytes(StandardCharsets.UTF_8));

        // 4. 转换为16进制字符串
        StringBuilder hexStr = new StringBuilder();
        for (byte b : digest) {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() == 1) {
                hexStr.append('0');
            }
            hexStr.append(hex);
        }

        // 5. 比较签名
        return hexStr.toString().equals(receivedSignature);
    }

    //AES解密数据
    private String decryptData(String encryptedData) throws Exception {
        // 1. Base64解码
        byte[] encryptedBytes = Base64.getDecoder().decode(encryptedData);

        // 2. 处理AES密钥
        byte[] aesKeyBytes = Base64.getDecoder().decode(encodingAESKey + "=");
        byte[] ivBytes = Arrays.copyOfRange(aesKeyBytes, 0, 16);

        // 3. 初始化Cipher
        SecretKeySpec keySpec = new SecretKeySpec(aesKeyBytes, "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(Cipher.DECRYPT_MODE, keySpec, ivSpec);

        // 4. 解密
        byte[] decryptedBytes = cipher.doFinal(encryptedBytes);

        // 5. 处理PKCS5Padding补位
        int pad = decryptedBytes[decryptedBytes.length - 1];
        if (pad < 1 || pad > 32) {
            pad = 0;
        }

        return new String(
                Arrays.copyOfRange(decryptedBytes, 0, decryptedBytes.length - pad),
                StandardCharsets.UTF_8
        );
    }

    // 类成员变量记录已处理的事件
    private final Set<String> startProcessedEvents = Collections.synchronizedSet(new HashSet<>());
    private final Set<String> sendProcessedEvents = Collections.synchronizedSet(new HashSet<>());

    //处理事件业务逻辑
    private void processEvent(String decryptedData) {
        // 这里可以解析JSON并处理具体业务
        // 示例: 打印事件数据
        logger.info("这是获取到的会议信息：");
        logger.info("Processing event: {}", decryptedData);
        String json = decryptedData;
        try {
            ObjectMapper mapper = new ObjectMapper();

            // 解析JSON
            java.util.Map<String, Object> jsonMap = mapper.readValue(json, java.util.Map.class);

            // 1. 提取 event
            String event = (String) jsonMap.get("event");
            // 获取payload数组
            java.util.List<java.util.Map<String, Object>> payload = (java.util.List<java.util.Map<String, Object>>) jsonMap.get("payload");
            java.util.Map<String, Object> firstPayload = payload.get(0);
            // 获取meeting_info信息
            java.util.Map<String, Object> meetingInfo = (java.util.Map<String, Object>) firstPayload.get("meeting_info");
            String meetingId = (String) meetingInfo.get("meeting_id");
            Map<String, Object> operator = (Map<String, Object>) firstPayload.get("operator");
            String operatorUserId = (String) operator.get("userid");
            String instanceIdStr = (String) operator.get("instance_id");
            Integer instanceId = Integer.parseInt(instanceIdStr);

            //判断事件是否为开始会议
            if ("meeting.started".equals(event)) {

                try {
                    // 生成唯一事件ID（使用事件类型+会议ID+时间戳）
                    String eventId = meetingId;
                    // 检查是否已处理
                    if (startProcessedEvents.contains(eventId)) {
                        //System.out.println("忽略已处理事件: " + eventId);
                        logger.info("忽略已处理事件: {}", eventId);
                        return;
                    }
                    // 记录已处理事件
                    startProcessedEvents.add(eventId);

                    // 原有处理逻辑...
                } catch (Exception e) {
                    e.printStackTrace();
                }
                //开启语音转写功能
                //System.out.println("开启会议语音转写");
                logger.info("开启会议语音转写");
                ObjectMapper jsonMapper = new ObjectMapper();
                ObjectNode jsonBody = jsonMapper.createObjectNode()
                        .put("operator_id", operatorUserId)
                        .put("operator_id_type", 1)
                        .put("instance_id", instanceId)  // 自动识别为数字类型
                        .put("is_open", true)
                        .put("open_asr_view", 0);
                String BODY_JSON = mapper.writeValueAsString(jsonBody);
                V1RealControlMeetingsMeetingIdAsrPutRequest body = JSON.parseObject(BODY_JSON, V1RealControlMeetingsMeetingIdAsrPutRequest.class);

                // 2.构造请求参数
                MeetingControlApi.ApiV1RealControlMeetingsMeetingIdAsrPutRequest request =
                        new MeetingControlApi.ApiV1RealControlMeetingsMeetingIdAsrPutRequest.Builder(meetingId)
                                .body(body).build();
                // 3.构造 JWT 鉴权器
                // 随机数
                BigInteger nonce = BigInteger.valueOf(Math.abs((new SecureRandom()).nextInt()));
                // 当前时间戳
                String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
                AuthenticatorBuilder<JWTAuthenticator> authenticatorBuilder =
                        new JWTAuthenticator.Builder().nonce(nonce).timestamp(timestamp);
                try {
                    MeetingControlApi.ApiV1RealControlMeetingsMeetingIdAsrPutResponse response =
                            client.meeting_control().v1RealControlMeetingsMeetingIdAsrPut(request, authenticatorBuilder);
                    // response from `v1RealControlMeetingsMeetingIdAsrPut`: V1RealControlMeetingsMeetingIdAsrPut200Response
                    logger.info("Response from `MeetingControlApi.v1RealControlMeetingsMeetingIdAsrPut`: \nheader: {}\n{}",
                            response.getHeader(), response.getData());
                } catch (ClientException e) {
                    logger.error("Error when calling `MeetingControlApi.v1RealControlMeetingsMeetingIdAsrPut`", e);
                    throw new RuntimeException(e);
                } catch (ServiceException e) {
                    logger.error("Error when calling `MeetingControlApi.v1RealControlMeetingsMeetingIdAsrPut`", e);
                    logger.error("Full HTTP response: {}", new String(e.getApiResp().getRawBody()));
                    throw new RuntimeException(e);
                }
            } else if ("meeting.end".equals(event)) {

                try {
                    // 生成唯一事件ID（使用事件类型+会议ID+时间戳）
                    String eventId = meetingId;
                    // 检查是否已处理
                    if (sendProcessedEvents.contains(eventId)) {
                        logger.info("忽略已处理事件: {}", eventId);
                        return;
                    }
                    // 记录已处理事件
                    sendProcessedEvents.add(eventId);

                    // 原有处理逻辑...
                } catch (Exception e) {
                    e.printStackTrace();
                }
                logger.info("operatorId: {}", operatorUserId);
                logger.info("meetingId: {}", meetingId);
                // 2.构造请求参数
                MeetingsApi.ApiV1AsrDetailsGetRequest request =
                        new MeetingsApi.ApiV1AsrDetailsGetRequest.Builder()
                                .operatorIdType("1")
                                .operatorId(operatorUserId)
                                .meetingId(meetingId)
                                .fileType("1")
                                .build();
                // 3.构造 JWT 鉴权器
                // 随机数
                BigInteger nonce = BigInteger.valueOf(Math.abs((new SecureRandom()).nextInt()));
                // 当前时间戳
                String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
                AuthenticatorBuilder<JWTAuthenticator> authenticatorBuilder =
                        new JWTAuthenticator.Builder().nonce(nonce).timestamp(timestamp);
                // 4.发送对应的请求
                try {
                    ApiResponse response =
                            client.meetings().v1AsrDetailsGet(request, authenticatorBuilder);
                    logger.info("Response from `MeetingsApi.v1AsrDetailsGet`: \nheader: {}\n{}",
                            response.getHeader(), response.getRawBody());
                    String rawBodyString = new String(response.getRawBody(), StandardCharsets.UTF_8);
                    logger.info("Raw Body (string): {}", rawBodyString);
                    try {
                        // 解析JSON获取下载URL
                        com.fasterxml.jackson.databind.ObjectMapper resultmapper = new com.fasterxml.jackson.databind.ObjectMapper();
                        java.util.Map<String, Object> result = resultmapper.readValue(rawBodyString, java.util.Map.class);
                        String downloadUrl = ((java.util.List<String>) result.get("download_url")).get(0);
                        // 设置保存路径为D盘根目录
                        String savePath = "D:/" + meetingId + ".docx";
                        String targetPath = "D:/" + meetingId + "纪要" + ".docx";
                        // 下载文件
                        logger.info("开始下载文件到: {}", savePath);
                        try (java.io.BufferedInputStream in = new java.io.BufferedInputStream(new java.net.URL(downloadUrl).openStream());
                             java.io.FileOutputStream fileOutputStream = new java.io.FileOutputStream(savePath)) {
                            byte[] dataBuffer = new byte[1024];
                            int bytesRead;
                            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                                fileOutputStream.write(dataBuffer, 0, bytesRead);
                            }
                            logger.info("文件下载完成，已保存到 {}", savePath);
                            //将文件传送给大模型处理
                            try {
                                boolean success = MeetingMinutesGenerator.generateMinutesFromWord(
                                        savePath,
                                        targetPath,
                                        "AKIAXFAXF62IWJXGLVEE.LnKInaahcMZG9zLsGMH3nTLOw3S3lK5Vcu0+ifnO",
                                        "https://bedrock.chatbot.cn/llm/sse-invoke"
                                );

                                if (success) {
                                    logger.info("会议纪要生成成功！");
                                }
                            } catch (IOException e) {
                                logger.error("错误: {}", e.getMessage());
                            }
                            //使用邮箱发送邮件
                            // 1.获得主持人的腾讯会议userid
                            // 2.根据获得的腾讯会议userid获得员工的企业微信userid
                            // 3.根据企业微信userid查询员工表获得员工邮箱
                            String tid = operatorUserId;
                            String wid = userIdMapper.getWidByTid(tid);
                            String tenantId = "1806976109082972160";
                            String emailAddress = sysUserSysMapper.getCompanyEmail(wid, tenantId);
                            if (StringUtils.isEmpty(emailAddress)) {
                                logger.info("用户：{}", wid, "没有企业邮箱");
                                return;
                            }
                            Thread.sleep(10000);
                            EmailSender emailSender = new EmailSender();
                            //response.getRawBody()
//                            boolean mailFlag = emailSender.sendEmailWithAttachment(emailAddress,
//                                    targetPath,
//                                    "重要文件",
//                                    "您好：\n" +
//                                            "\n" +
//                                            "         附件为您本次会议的会议纪要，烦请下载查看，如需对会议纪要结果进行修改或查看历史会议，可点击下方链接。");
//                            if (mailFlag) {
//                                logger.info("邮件发送成功");
//                            } else {
//                                logger.error("邮件发送失败");
//                            }
                        }
                    } catch (Exception e) {
                        logger.error("下载文件时出错: {}", e.getMessage());
                        e.printStackTrace();
                    }
                } catch (ClientException e) {
                    logger.error("Error when calling `MeetingsApi.v1AsrDetailsGet`", e);
                    throw new RuntimeException(e);
                } catch (ServiceException e) {
                    logger.error("Error when calling `MeetingsApi.v1AsrDetailsGet`", e);
                    logger.error("Full HTTP response: {}", new String(e.getApiResp().getRawBody()));
                    throw new RuntimeException(e);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
