package com.cmeeting.controller;

import com.cmeeting.service.ISysUserSyncCategoryService;
import com.cmeeting.service.SysUserSyncService;
import com.cmeeting.util.R;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

@RestController
@RequestMapping("/user/sync")
public class SysUseSyncController {

    @Value("${permission.tenantId}")
    private String tenantId;
    @Resource
    private ISysUserSyncCategoryService iSysUserSyncCategoryService;
    @Resource
    private SysUserSyncService iSysUserSyncService;

    @GetMapping("/category/tree")
    public R tree() {
        return R.ok(iSysUserSyncCategoryService.tree());
    }
    @GetMapping("/list")
    public R list(@RequestParam String categoryId, @RequestParam Integer current, @RequestParam Integer size, String search) {
        return R.ok(iSysUserSyncService.selectPage(current, size, categoryId, search));
    }

    @GetMapping("/getTree")
    public R getTree(){
        return R.ok(iSysUserSyncService.getTreeList());
    }

    @GetMapping("/downloadTree")
    public void downloadTree(HttpServletResponse response){
        iSysUserSyncService.downloadTree(iSysUserSyncService.getTreeList(), response);
    }

}
