package com.cmeeting.pojo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import jdk.nashorn.internal.ir.annotations.Ignore;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 会议信息实体类
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("cmt_meeting_info")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class MeetingInfo implements Serializable {

    private static final long serialVersionUID = -26238487532381000L;
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Integer id;
    /**
     * 会议主题
     */
    private String subject;

    /**
     * 会议ID（字符串类型）
     */
    private String meetingId;

    /**
     * 子会议ID
     */
    private String subMeetingId;

    /**
     * 会议号码
     */
    private String meetingCode;

    /**
     * 主持人
     */
    private String host;

    /**
     * 主持人uid-腾讯会议用户id
     */
    private String hostUid;

    /**
     * 参会人员名单
     */
    private String participantUsers;

    /**
     * 会议开始时间（时间戳）
     */
    @DateTimeFormat(pattern = "yyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private LocalDateTime startTime;

    /**
     * 会议结束时间（时间戳）
     */
    @DateTimeFormat(pattern = "yyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private LocalDateTime endTime;

    /**
     * 是否生成会议纪要完成
     */
    private Boolean isGenerated;
    /**
     * 生成纪要许可
     */
    private Boolean emailGenerateAccess;
    /**
     * 推送邮件许可 为false不推送
     */
    private Boolean emailPushAccess;
    /**
     * 是否推送邮件完成
     */
    private Boolean isPushed;
    /**
     * 会议状态： 0新会议待处理 1生成纪要失败 2生成纪要成功 3推送邮件成功 4推送邮件失败 5转录文件为空
     */
    private Integer status;
    /**
     * 会议纪要重新生成标识
     */
    private Boolean generateRetry;
    /**
     * 邮件推送重试标识
     */
    private Boolean pushRetry;
    /**
     * 同步时间
     */
    @DateTimeFormat(pattern = "yyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private LocalDateTime syncTime;

    /**
     * 转录文本
     */
    private String recordContent;

    /**
     * 纪要xml
     */
    private String recordXml;
    /**
     * 每个会议对应的转录文件id，多个用逗号分隔,按参会前后升序
     */
    private String recordFileId;
    /**
     * 邮箱
     */
    private String email;
    /**
     * 更新时间
     */
    @DateTimeFormat(pattern = "yyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private LocalDateTime updateTime;

    /**
     * 模板ID
     */
    private Integer templateId;

    /**
     * 转录文件知识库id
     */
    private String transDocId;

    @TableField(exist = false)
    private String userId;
}