package com.cmeeting.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.cmeeting.annotation.OperLog;
import com.cmeeting.pojo.MeetEmailTemplate;
import com.cmeeting.service.MeetEmailTemplateService;
import com.cmeeting.util.R;
import com.cmeeting.util.RedisUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;


@RestController
@RequestMapping("/email")
public class EmailController {

    @Autowired
    private MeetEmailTemplateService meetEmailTemplateService;

    @OperLog(location = "邮件通知内容管理", operation = "修改邮件通知内容")
    @PostMapping("/edit")
    public R edit(@RequestBody MeetEmailTemplate param){
        String content = param.getContent();

        Date now = new Date();
        MeetEmailTemplate meetEmailTemplate = new MeetEmailTemplate();
        meetEmailTemplate.setContent(content);
        meetEmailTemplate.setCreateTime(now);
        meetEmailTemplate.setUpdateTime(now);

        meetEmailTemplateService.save(meetEmailTemplate);
        return R.ok();
    }

    @GetMapping("/get")
    public R getTemplate(){

        MeetEmailTemplate template = meetEmailTemplateService.getOne(new LambdaQueryWrapper<MeetEmailTemplate>().orderByDesc(MeetEmailTemplate::getId).last("LIMIT 1"));


        return R.ok(template);
    }
}
