package com.cmeeting.util.page;

import com.cmeeting.util.R;
import com.cmeeting.util.page.domain.PageDomain;
import com.cmeeting.util.page.domain.TableData;
import com.cmeeting.util.page.domain.TableSupport;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.util.ObjectUtils;

import java.util.List;

public class PageUtil {


    /**
     * 设置请求分页数据
     */
    public static void startPage() {
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = pageDomain.getPageNum();
        Integer pageSize = pageDomain.getPageSize();
        if (!ObjectUtils.isEmpty(pageNum) && !ObjectUtils.isEmpty(pageSize)) {
            PageHelper.startPage(pageNum, pageSize);
        }
    }

    /**
     * 设置请求分页数据
     * @param pageNum 页号
     * @param pageSize 页大小
     */
    public static void startPage(Integer pageNum, Integer pageSize) {
        pageNum = ObjectUtils.isEmpty(pageNum) ? TableSupport.DEFAULT_PAGE_NUM : pageNum;
        pageSize = ObjectUtils.isEmpty(pageSize) ? TableSupport.DEFAULT_PAGE_SIZE : pageSize;

        if (!ObjectUtils.isEmpty(pageNum) && !ObjectUtils.isEmpty(pageSize)) {
            PageHelper.startPage(pageNum, pageSize);
        }
    }

    /**
     * 分页
     *
     * @param size    分页参数
     * @param current 分页参数
     * @param orderby 排序规则
     */
    public static void startPage(Integer size, Integer current, String orderby) {

        if (!ObjectUtils.isEmpty(current) && !ObjectUtils.isEmpty(size)) {
            if (ObjectUtils.isEmpty(orderby)) {
                PageHelper.startPage(current, size);
            } else {
                PageHelper.startPage(current, size, orderby);
            }
        } else {
            startPage(orderby);
        }
    }

    /**
     * 设置请求分页数据
     */
    public static void startPage(String orderby) {
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = pageDomain.getPageNum();
        Integer pageSize = pageDomain.getPageSize();
        if (!ObjectUtils.isEmpty(pageNum) && !ObjectUtils.isEmpty(pageSize)) {
            if (ObjectUtils.isEmpty(orderby)) {
                PageHelper.startPage(pageNum, pageSize);
            } else {
                PageHelper.startPage(pageNum, pageSize, orderby);
            }
        }
    }

    /**
     * 排序
     * @param orderBy
     */
    public static void orderBy(String orderBy) {
        PageHelper.orderBy(orderBy);
    }

    /**
     * 响应请求分页数据
     */
    @SuppressWarnings({"rawtypes", "unchecked"})
    public static R getDataTable(List<?> list) {
        PageInfo pageInfo = new PageInfo(list);

        TableData tableData = new TableData();
        tableData.setRows(list);
        tableData.setTotal(pageInfo.getTotal());
        tableData.setTotalPage(pageInfo.getPages());

        return R.ok(tableData);
    }

    public static R getDataTable(PageInfo<?> pageInfo) {

        TableData tableData = new TableData();
        tableData.setRows(pageInfo.getList());
        tableData.setTotal(pageInfo.getTotal());
        tableData.setTotalPage(pageInfo.getPages());

        return R.ok(tableData);
    }
}
