// vo/LoginVO.java
package com.cmeeting.dto;

import com.cmeeting.pojo.MeetingRecordTemplate;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class UserDTO {
    /**
     * 员工姓名
     */
    private String userName;

    /**
     * 企业微信userid
     */
    private String wid;

    /**
     * 腾讯会议userid
     */
    private String tid;
    /**
     * 邮箱
     */
    private String email;

    /**
     * 邮件推送许可（企微表存储）
     */
    private Boolean emailPushAccess;

    @Override
    public String toString() {
        return "UserDTO{" +
                "userName='" + userName + '\'' +
                ", wid='" + wid + '\'' +
                ", tid='" + tid + '\'' +
                ", email='" + email + '\'' +
                '}';
    }


    /**
     * 已授权模版的人员
     */
    @Data
    @Builder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class TemplateAuthorizedUserDTO {
        /**
         * 模板id
         */
        private Integer recordTemplateId;
        /**
         * 模板
         */
        private MeetingRecordTemplate recordTemplate;

        /**
         * 企业微信userid
         */
        private List<String> userIdList;
    }
}