package com.cmeeting.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @Description
 * @Author zhang kaishi
 * @Date 2025/7/18 16:53
 **/
@Data
public class MeetTypeDto {

    // 会议类型id
    private Long id;
    // 类型名称
    private String name;
    // 允许用户在此类型下自定义创建模板，0-不允许，1-允许(默认)
    private Integer personalPermission;
    // 授权类型。0-不授权，1-授权给所有人(默认)，2-自定义
    private Integer authType;
    // 参考类型id
    private Long relId;
    // 类型描述的内容
    private String content;
    // 匹配类型的正则
    private String regex;
    // 创建者
    private String createUser;
    // 创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    // 会议模板
    private List<RecordTemplateDto> recordTemplateDTOList;
}