package com.cmeeting.pojo;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 核心模块权限实体类
 *
 * aigc后台系统中智能体权限类
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("core_module_permission")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CoreModulePermissions implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 类型(0:分类, 1:用户)
     */
    private Integer type;

    /**
     * 用户类型(0:自建, 1:应用, 2:通讯录)
     */
    private Integer userType;

    /**
     * 关联ID
     */
    private String relId;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",locale = "zh", timezone = "GMT+8")
    @TableField(fill = FieldFill.INSERT)
    private Date createTime = new Date();


    /**
     * 目标ID
     */
    private String targetId;

    /**
     * 租户ID
     */
    private String tenantId;

}