package com.cmeeting.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.cmeeting.ad.util.SecurityUtil;
import com.cmeeting.annotation.OperLog;
import com.cmeeting.constant.CategoryConstant;
import com.cmeeting.constant.PermissionPruposeType;
import com.cmeeting.pojo.ModulePermission;
import com.cmeeting.service.ModulePermissionService;
import com.cmeeting.util.R;
import com.cmeeting.vo.AuthVO;
import com.cmeeting.vo.PermissionVO;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

@RestController
@RequestMapping("/permission")
public class PermissionController {
    @Resource
    private ModulePermissionService modulePermissionService;

    /**
     * 查询待选择用户接口
     *
     * @return 树形结构部门
     */
    @PostMapping("/list")
    public R list(@Validated @RequestBody PermissionVO.CheckList vo) {
        return R.ok(modulePermissionService.permissionList(vo.getSearch(), vo.getCategoryId(), vo.getUserType(), vo.getPurpose(), vo.getTargetId(), null, null));
    }

    /**
     * 已授权用户
     *
     * @param vo
     * @return
     */
    @PostMapping("/authList")
    public R authList(@Validated @RequestBody PermissionVO.CheckedList vo) {
        return R.ok(modulePermissionService.checkedList(vo.getSearch(), vo.getPurpose(), vo.getTargetId()));
    }


    /**
     * 授权用户
     * @param vo
     * @return
     */
    @OperLog(location = "授权页面", operation = "授权用户")
    @PostMapping("/auth")
    public R auth(@Validated @RequestBody AuthVO vo) {
        return R.ok(modulePermissionService.auth(vo.getAuthData()));
    }

    /**
     * 取消授权
     * @param vo
     * @return
     */
    @OperLog(location = "授权页面", operation = "取消授权")
    @PostMapping("/remove")
    @Transactional(rollbackFor = Exception.class)
    public R remove(@Validated @RequestBody AuthVO vo) {
        for (AuthVO.Add authDatum : vo.getAuthData()) {
            boolean needTarget = authDatum.getPurpose().equals(PermissionPruposeType.TEMPLATE_TYPE_PERMISSION)
                    || authDatum.getPurpose().equals(PermissionPruposeType.TEMPLATE_PERMISSION);
            if (needTarget && authDatum.getTargetId() == null) {
                throw new RuntimeException("param error! `purpose` equals 1 or 2, but `targetId` is null.");
            }
            modulePermissionService.remove(new LambdaQueryWrapper<ModulePermission>()
                    .eq(!authDatum.getRelId().equals(CategoryConstant.ALL_EN), ModulePermission::getType, authDatum.getType())
                    .eq(!authDatum.getRelId().equals(CategoryConstant.ALL_EN), ModulePermission::getUserType, authDatum.getUserType())
                    .eq(ModulePermission::getPurpose, authDatum.getPurpose())
                    .eq(!authDatum.getRelId().equals(CategoryConstant.ALL_EN), ModulePermission::getRelId, authDatum.getRelId())
                    .eq(authDatum.getTargetId() != null, ModulePermission::getTargetId, authDatum.getTargetId()));
        }
        return R.ok();
    }


    /**
     * 用户自己取消使用生成纪要功能列表
     * @return
     */
    @GetMapping("/cancelList")
    public R cancelList(String query) {
       return R.ok(modulePermissionService.personalCancelList(query));
    }

    /**
     * 用户自己取消使用生成纪要功能
     */
    @GetMapping("/personalSwitch")
    public R personalSwitch(@Validated@NotNull Boolean enable) {
        return R.ok(modulePermissionService.personalSwitch(SecurityUtil.getUser().getId(), enable));
    }

    /**
     * 个人页面开关纪要功能状态查询
     * @return
     */
    @GetMapping("/personalStatus")
    public R personalStatus() {
        return R.ok(modulePermissionService.personalStatus(SecurityUtil.getUser().getId()));
    }


}
