package com.cmeeting.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cmeeting.pojo.OperationLog;
import com.cmeeting.service.OperationLogService;
import com.cmeeting.mapper.primary.OperationLogMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
* @author Administrator
* @description 针对表【operation_log(操作日志)】的数据库操作Service实现
* @createDate 2025-07-17 10:03:44
*/
@Service
public class OperationLogServiceImpl extends ServiceImpl<OperationLogMapper, OperationLog>
    implements OperationLogService{

    @Autowired
    private OperationLogMapper operationLogMapper;

    /**
     * 获取操作日志列表
     *
     * @param searchValue     用户姓名/员工号
     * @param createTimeStart 开始时间
     * @param createTimeEnd   结束时间
     * @return
     */
    @Override
    public List<OperationLog> list(String searchValue, Date createTimeStart, Date createTimeEnd) {

        return operationLogMapper.selectOperLogList(searchValue, createTimeStart, createTimeEnd);
    }
}




