package com.cmeeting.util;

import com.alibaba.fastjson.JSONObject;
import com.cmeeting.constant.UserAdminRouteConstant;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

/**
 * @author a
 */
@Component
public class UserAdminTokenUtil {

    @Resource
    private RedisUtils redisUtils;
    @Resource
    private UserAdminConfig userAdminConfig;

    @Value("${userAdmin.appId}")
    private String appId;
    @Value("${userAdmin.secret}")
    private String secret;

    private String getAccessToken() {
        String key = "user_admin_token_" + appId;
        Object o = redisUtils.get(key);
        if (o != null) {
            return o.toString();
        }
        String url = userAdminConfig.getUserAdminDomain() + UserAdminRouteConstant.ACCESS_TOKEN;
        JSONObject body = new JSONObject();
        body.put("appId", appId);
        body.put("secret", secret);
        JSONObject object = HttpClientUtils.httpPost(url, body, null);
        if (object != null && object.getInteger("code") == 0) {
            String data = object.getString("data");
            redisUtils.set(key, data, 7000);
            return data;
        } else {
            throw new RuntimeException("获取accessToken失败");
        }
    }

    private static UserAdminTokenUtil util;

    @PostConstruct
    public void init() {
        util = this;
    }

    public static String getUserAdminToken() {
        return util.getAccessToken();
    }
}
