package com.cmeeting.email;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ConnectingIdType;
import microsoft.exchange.webservices.data.core.enumeration.misc.TraceFlags;
import microsoft.exchange.webservices.data.core.enumeration.property.BodyType;
import microsoft.exchange.webservices.data.core.enumeration.property.Importance;
import microsoft.exchange.webservices.data.core.request.HttpWebRequest;
import microsoft.exchange.webservices.data.core.service.item.EmailMessage;
import microsoft.exchange.webservices.data.credential.ExchangeCredentials;
import microsoft.exchange.webservices.data.misc.ImpersonatedUserId;
import microsoft.exchange.webservices.data.property.complex.EmailAddress;
import microsoft.exchange.webservices.data.property.complex.MessageBody;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public class TestExchangeAndOauth2 {

    public static void main(String[] args) throws Exception {
        String mailAddress = "cmeeting_assistant@cimc.com";
        String tenant_id = "8653b3e-03c7-499e-8baf-42ef06a814ef";
        String client_id = "c06fe7cf-2a89-4099-9805-ce03031938f8";
        String client_secret = "wsu8Q~GxYxPLf2akioQZDRG8NR1EzCAHIAQRVc6u";//注意不是密钥的id
        String scope = "https://outlook.office365.com/.default";
        String url = "https://login.microsoftonline.com/" + tenant_id + "/oauth2/v2.0/token";
//        String scope = "https://partner.outlook.cn/.default";//中国版（21v世纪互联运营的）的微软邮箱账号需要设置这个地址
//        String url = "https://login.partner.microsoftonline.cn/" + tenant_id + "/oauth2/v2.0/token";//中国版（21v世纪互联运营的）的微软邮箱账号需要设置这个地址

        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod(url);
        postMethod.addRequestHeader("accept", "*/*");
        postMethod.addRequestHeader("connection", "Keep-Alive");
        postMethod.addRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=GBK");

        //必须设置下面这个Header
        postMethod.addRequestHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.81 Safari/537.36");
        //添加请求参数
        postMethod.addParameter("grant_type", "client_credentials");
        postMethod.addParameter("client_id", client_id);
        postMethod.addParameter("client_secret", client_secret);
        postMethod.addParameter("scope", scope);
        String token = "";

        try {
            int code = httpClient.executeMethod(postMethod);
            String resBody = postMethod.getResponseBodyAsString();
            if (code == 200) {
                Map<String, Object> map = JSON.parseObject(resBody, Map.class);
                token = (String) map.get("access_token");
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            postMethod.releaseConnection();
        }

        ExchangeService service = new ExchangeService();

        service.setCredentials(new OAuth2Credentials(token));
        service.setTraceEnabled(true);
        service.traceMessage(TraceFlags.EwsRequest, "office365");
        service.setImpersonatedUserId(new ImpersonatedUserId(ConnectingIdType.SmtpAddress, mailAddress));
        service.setUrl(new URI("https://outlook.office365.com/ews/exchange.asmx"));
        //service.setUrl(new URI("https://partner.outlook.cn/ews/exchange.asmx"));//中国版（21v世纪互联运营的）的微软邮箱账号需要设置这个地址
        service.getHttpHeaders().put("X-AnchorMailbox", mailAddress);

        EmailMessage msg = new EmailMessage(service);
        msg.setFrom(new EmailAddress("mailAddress", mailAddress));
        msg.getToRecipients().add(new EmailAddress("收件人邮箱昵称", "binzhai321@outlook.com"));
        msg.setSubject("邮件oauth2测试");
        MessageBody messageBody = new MessageBody();
        messageBody.setBodyType(BodyType.Text);
        messageBody.setText("哈哈哈哈");
        msg.setBody(messageBody);

        msg.setImportance(Importance.Normal);
        msg.send();
    }

     static class OAuth2Credentials extends ExchangeCredentials {
         private String accessToken;

         public OAuth2Credentials(String accessToken) {
             Preconditions.checkNotNull(accessToken);
             this.accessToken = accessToken;
         }

         @Override
         public void prepareWebRequest(HttpWebRequest client)
                 throws URISyntaxException {
             super.prepareWebRequest(client);
             if (client.getHeaders() != null) client.getHeaders().put("Authorization", "Bearer " + accessToken);
         }
    }
}

