package com.cmeeting.config;

import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.ThreadPoolExecutor;

@Configuration
@Slf4j
public class ThreadPoolConfig {

    @Bean("fileProcessExecutor")
    public ThreadPoolTaskExecutor fileProcessExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        // 核心线程数 (CPU密集型任务建议核心数+1)
        executor.setCorePoolSize(4); // 固定核心线程数，避免动态获取CPU核心数
        // 最大线程数
        executor.setMaxPoolSize(4);
        // 队列容量
        executor.setQueueCapacity(1000);
        // 线程名前缀
        executor.setThreadNamePrefix("file-process-");

        // 明确设置所有必要属性
        executor.setAllowCoreThreadTimeOut(false); // 核心线程不允许超时
        executor.setWaitForTasksToCompleteOnShutdown(true); // 优雅关闭
        executor.setAwaitTerminationSeconds(60); // 等待任务完成的最大时间

        // 拒绝策略
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());

        // 初始化前打印配置检查
        log.info("Initializing ThreadPool: core={}, max={}",
                executor.getCorePoolSize(),
                executor.getMaxPoolSize());

        executor.initialize();
        return executor;
    }


    @Bean("emailProcessExecutor")
    public ThreadPoolTaskExecutor emailProcessExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        // 核心线程数 (CPU密集型任务建议核心数+1)
        executor.setCorePoolSize(1); // 固定核心线程数，避免动态获取CPU核心数
        // 最大线程数
        executor.setMaxPoolSize(5);
        // 队列容量
        executor.setQueueCapacity(1000);
        // 线程名前缀
        executor.setThreadNamePrefix("email-process-");

        // 明确设置所有必要属性
        executor.setAllowCoreThreadTimeOut(false); // 核心线程不允许超时
        executor.setWaitForTasksToCompleteOnShutdown(true); // 优雅关闭
        executor.setAwaitTerminationSeconds(60); // 等待任务完成的最大时间

        // 拒绝策略
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());

        // 初始化前打印配置检查
        log.info("Initializing ThreadPool: core={}, max={}",
                executor.getCorePoolSize(),
                executor.getMaxPoolSize());

        executor.initialize();
        return executor;
    }
}