package com.cmeeting.vo;


import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

;

/**
 * 会议纪要模板展示层
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class StatisticsEmailPush {

    private List<ToEmail> toEmails;

    private String subject;
    private String content;

    /**
     * 附件
     */
    private List<Attachment> attachments;

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    public static class ToEmail {
        private String user;
        private String email;
    }
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    public static class Attachment {
        private String name;
        private byte[] bytes;
    }
}