package com.cmeeting.pojo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * 核心模块权限实体类
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CoreModulePermissions {
    /**
     * 主键ID
     */
    private String id;

    /**
     * 类型(0:分类, 1:用户)
     */
    private Integer type;

    /**
     * 用户类型(0:自建, 1:应用, 2:通讯录)
     */
    private Integer userType;

    /**
     * 来源(0:角色授权, 1:应用授权, 2:文档授权)
     */
    private Integer source;

    /**
     * 关联ID
     */
    private String relId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 目标ID
     */
    private String targetId;

    /**
     * 租户ID
     */
    private String tenantId;

    @Override
    public String toString() {
        return "CoreModulePermissions{" +
                "id='" + id + '\'' +
                ", type=" + type +
                ", userType=" + userType +
                ", source=" + source +
                ", relId='" + relId + '\'' +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", targetId='" + targetId + '\'' +
                ", tenantId='" + tenantId + '\'' +
                '}';
    }
}