package com.cmeeting.mapper.primary;

import com.baomidou.mybatisplus.annotation.SqlParser;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.cmeeting.ad.entity.ModulePermissions;
import com.cmeeting.ad.entity.SysMenu;
import com.cmeeting.ad.vo.ApplicationVo;
import com.cmeeting.pojo.User;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 租户表 Mapper 接口
 * </p>
 *
 * @author robot
 * @since 2019-08-10
 */
public interface CommonMapper extends BaseMapper<User> {

    /**
     * 根据租户id获取菜单列表
     * @param tenantId
     * @return
     */
    @SqlParser(filter = true)
    List<SysMenu> getMenuList(@Param("tenantId")String tenantId);

    @SqlParser(filter = true)
    List<ModulePermissions> getRoleByTenantId(@Param("tenantId") String tenantId);

    @SqlParser(filter = true)
    List<SysMenu> getMenuByRoleList(@Param("roleIdList") List<String> roleIdList, @Param("tenantId") String tenantId);

    @SqlParser(filter = true)
    ApplicationVo getApplicationNoTenantId(@Param("applicationId")String applicationId);
}
