package com.cmeeting.log.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cmeeting.log.entity.ProcessLog;
import com.cmeeting.mapper.primary.ProcessLogMapper;
import com.cmeeting.log.service.ProcessLogService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

@Service
@Slf4j
public class ProcessLogServiceImpl extends ServiceImpl<ProcessLogMapper, ProcessLog>  implements ProcessLogService {
    @Override
    public boolean log(String meetingId, String subMeetingId, String message) {
        ProcessLog processLog = ProcessLog.builder().meetingId(meetingId).subMeetingId(subMeetingId).message(message).operateTime(LocalDateTime.now()).build();
        boolean save = save(processLog);
        return save;
    }
}
