package com.cmeeting.ad.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 租户表
 * </p>
 *
 * @author robot
 * @since 2019-08-10
 */
@Getter
@Setter
public class SysTenant implements Serializable {

    /**
     * 租户id
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    private String kefuId;

    /**
     * 租户名称
     */
    private String name;


    /**
     * 删除标记
     */
    @TableField(fill = FieldFill.INSERT)
    @TableLogic
    private Boolean isDel;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Date   updateTime;
    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private String createUser;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private String updateUser;

    /**
     * 有效期
     */
    private String validity;

    /**
     *  0纯网页 11企业微信第三方应用 12企业微信自建 21钉钉第三方应用 22钉钉自建 3 teams
     */
//    private Integer tenantType;

    /**
     * 启用状态(0: 启用, 1: 禁用)
     */
    private String status;

    /**
     * 备注
     */
    private String remarks;

    /**
     * 机器人数量
     */
    private Integer robotNums;

    /**
     * 知识点数量上限
     */
    private Integer qaNums;
    private Integer atlasNums;
    private Integer dialogNums;
    private Integer docNums;

    private Integer formNums;
    private Integer userNums;
    private Integer regulatorsNums;

    /**
     * 知创建租户的系统用户名称
     */
    private String userName;

    /**
     * 语言
     */
    private String language;


    @TableField(exist = false)
    private Boolean expired;
}
