package com.cmeeting.ad.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 菜单权限表
 * </p>
 *
 * @author robot
 * @since 2019-04-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("sys_menu")
public class SysMenu extends Model<SysMenu> {

    private static final long serialVersionUID = 1L;

    /**
     * 菜单ID
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Integer id;

    /**
     * 菜单名称
     */
    private String name;

    /**
     * 菜单权限标识
     */
    private String perms;

    /**
     * 前端path / 即跳转路由
     */
    private String path;

    /**
     * 菜单组件
     */
    private String component;

    /**
     * 父菜单ID
     */
    private Integer parentId;

    /**
     * 图标
     */
    private String icon;

    /**
     * 是否为外链
     */
    private Boolean isAdmin;

    /**
     * 排序
     */
    private Integer sort;

    /**
     * 菜单类型 （类型   1：目录   2：菜单   3：按钮）
     */
    private Integer type;

    /**
     * 所属大功能模块
     */
    private String parentSystem;

    /**
     * 在租户菜单是否展示 新增
     */
    private Integer isShow;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;

    @TableField(fill = FieldFill.INSERT)
    @TableLogic
    private Integer isDel;


    /**
     * 非数据库字段
     * 父菜单名称
     */
    @TableField(exist = false)
    private String parentName;

    /**
     * 非数据库字段
     * 菜单等级
     */
    @TableField(exist = false)
    private Integer level;

    /**
     * 非数据库字段
     * 子菜单
     */
    @TableField(exist = false)
    private List<SysMenu> children;

    @TableField(exist = false)
    private String parentPath;

    @TableField(exist = false)
    private String key;

    @TableField(exist = false)
    private String title;


    public String getTitle() {
        return name;
    }

    @Override
    public boolean equals(Object o) {
        return Objects.hash(id) == o.hashCode();
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
