package com.cmeeting.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.jetbrains.annotations.NotNull;

import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class AuthVO {
    @NotEmpty(message = "param authData cant be null!")
    private List<Add> authData;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Add {
        /**
         * 类型，0-分类，1-用户
         */
        @NotNull
        private Integer type;

        /**
         * 用户类型，2-通讯录，3-超管分享
         */
        @NotNull
        private Integer userType;

        /**
         * 0-授权纪要功能，1-纪要类型分享，2-纪要模板分享，3-用户自己关闭纪要功能
         */
        @NotNull
        private Integer purpose;

        /**
         * 关联id（分类id或用户id）    为all时 表示所有人授权/清空所有权限
         */
        @NotNull
        private String relId;

        /**
         * purpose为0/3时为空，为1时是纪要类型id，2时纪要模板id
         */
        private Long targetId;
    }
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Remove {
        /**
         * 类型，0-分类，1-用户
         */
        @NotNull
        private Integer type;

        /**
         * 用户类型，2-通讯录，3-超管分享
         */
        @NotNull
        private Integer userType;

        /**
         * 0-授权纪要功能，1-纪要类型分享，2-纪要模板分享，3-用户自己关闭纪要功能
         */
        @NotNull
        private Integer purpose;

        /**
         * 关联id（分类id或用户id）    为all时 表示所有人授权/清空所有权限
         */
        @NotNull
        private String relId;

        /**
         * purpose为0/3时为空，为1时是纪要类型id，2时纪要模板id
         */
        private Long targetId;
    }
}
