package com.cmeeting.util.page.domain;

import cn.hutool.core.util.StrUtil;
import com.cmeeting.util.ServletUtil;

/**
 * @Description
 * @Author zhang kaishi
 * @Date 2025/7/17 17:15
 **/
public class TableSupport {
    /**
     * 当前记录起始索引
     */
    public static final String PAGE_NUM = "current";

    /**
     * 默认分页号
     */
    public static final int DEFAULT_PAGE_NUM = 1;

    /**
     * 每页显示记录数
     */
    public static final String PAGE_SIZE = "size";

    /**
     * 默认每页显示记录数
     */
    public static final int DEFAULT_PAGE_SIZE = 10;

    /**
     * 排序列
     */
    public static final String ORDER_BY_COLUMN = "orderByColumn";

    /**
     * 排序的方向 "desc" 或者 "asc".
     */
    public static final String IS_ASC = "isAsc";

    /**
     * 封装分页对象
     */
    public static PageDomain getPageDomain() {
        PageDomain pageDomain = new PageDomain();
        String pageNum = ServletUtil.getRequest().getParameter(PAGE_NUM);
        String pageSize = ServletUtil.getRequest().getParameter(PAGE_SIZE);
        pageDomain.setPageNum(StrUtil.isNotBlank(pageNum) ? Integer.parseInt(pageNum) : DEFAULT_PAGE_NUM);
        pageDomain.setPageSize(StrUtil.isNotBlank(pageSize) ? Integer.parseInt(pageSize) : DEFAULT_PAGE_SIZE);
        return pageDomain;
    }

    public static PageDomain buildPageRequest() {
        return getPageDomain();
    }

}
