package com.cmeeting.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.cmeeting.ad.entity.SysUserSync;
import com.cmeeting.dto.PermissionCheckedDTO;
import com.cmeeting.dto.SysUserSyncDTO;
import com.cmeeting.pojo.SysUserSyncCategory;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

import java.util.List;
import java.util.Map;


public interface SysUserSyncService extends IService<SysUserSync> {
    /**
     * 根据工号查询部门 limit 1
     * @param userId
     * @return
     */
    String getDeptPathByUserId(String userId);

    /**
     * 根据工号查询部门集合（部分人在两个部门下）
     * @param userId
     * @return
     */
    List<String> getDeptPathByUserIdAndInSet(String userId);

    /**
     * 向上获取部门集合，包含当前部门
     *
     * @return
     */
    List<SysUserSyncCategory> getCategoryListByUserId(String userId);


    PermissionCheckedDTO listByCategoryId(String categoryId, String search, List<String> categoryList, List<String> userList);

    List<PermissionCheckedDTO.User> findInUserIdsOrShareCateIds(List<String> userIds, List<String> shareCateIds, String search);

    List<PermissionCheckedDTO.User> findByParam(List<String> userIds, List<String> notInCateIds, List<String> shareCateIds, String search, String categoryId);

    Page<SysUserSyncDTO> selectPage(Integer current, Integer size, String categoryId, String search);

    List<SysUserSync> listByUserIds(List<String> userIdList, String search);

    List<SysUserSyncCategory> getTreeList();

    void downloadTree(List<SysUserSyncCategory> list, HttpServletResponse response);

    String getDeptPathName(String path, String deptId);
}
