package com.cmeeting.service;

import com.cmeeting.dto.MeetTypeDto;
import com.cmeeting.pojo.MeetType;
import com.baomidou.mybatisplus.extension.service.IService;
import com.cmeeting.vo.MeetingTypeVo;

import java.util.List;

/**
* @author Administrator
* @description 针对表【meet_type(会议类型)】的数据库操作Service
* @createDate 2025-07-17 10:55:32
*/
public interface MeetTypeService extends IService<MeetType> {

    /**
     * 添加会议类型
     * @param meetingTypeVo 请求参数
     */
    void add(MeetingTypeVo meetingTypeVo);

    /**
     * 更新会议类型
     * @param meetingTypeVo
     */
    void update(MeetingTypeVo meetingTypeVo);

    /**
     * 根据id删除会议类型
     * @param id 会议类型id
     */
    void delete(Long id);


    /**
     * 获取会议类型
     * @return
     */
    List<MeetTypeDto> getMeetTypeList();


    /**
     * 获取会议类型下拉框
     * @return
     */
    List<MeetTypeDto> getMeetTypeSelect();

}
