package com.cmeeting.service;

import com.cmeeting.job.FileProcessTask;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class FileProcessCallbackHandler {
    
    // 单个任务完成回调
    public void onComplete(FileProcessTask task) {
        // 可以记录任务状态、发送通知等
        log.info("任务处理完成: meetingId {}", task.getMeetingId());
        
        // 更新数据库状态等
        // taskRepository.updateStatus(task.getId(), "COMPLETED");
    }
    
    // 所有任务完成回调
    public void onAllComplete() {
        log.info("所有文件处理任务已完成");
        // 可以发送全局通知等
    }
}