package com.cmeeting.pojo;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 外接系统部门表(SysUserSyncCategory)实体类
 *
 * @author makejava
 * @since 2024-04-25 14:22:52
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("sys_user_sync_category")
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class SysUserSyncCategory implements Serializable {
    private static final long serialVersionUID = 717019603610366063L;
    /**
     * 外接系统部门表主键
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;
    /**
     * 部门id
     */
    private String deptId;
    /**
     * 部门名称
     */
    private String name;
    private String path;
    /**
     * 部门别名
     */
    private String nameEn;
    /**
     * 部门领导，多个领导用逗号隔开
     */
    private String departmentLeader;
    /**
     * 父级id
     */
    private String parentId;
    /**
     * 排序
     */
    private Integer sortNo;
    /**
     * 租户id
     */
//    private String tenantId;

}
