package com.cmeeting.pojo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 会议纪要模板权限实体类
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("cmt_record_template_permission")
public class RecordTemplatePermission implements Serializable {

    private static final long serialVersionUID = -26238487532381000L;
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 模板id
     */
    @TableId(type = IdType.AUTO)
    private Integer templateId;

    /**
     * 模板类型
     */
    private String templateType;

    /**
     * 对象类型
     */
    private String relType;

    /**
     * 对象id
     */
    private String relId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;
}