package com.cmeeting.pojo;

import com.baomidou.mybatisplus.annotation.*;

import java.util.Date;
import lombok.Data;

/**
 * 会议类型
 * @TableName meet_type
 */
@TableName(value ="meet_type")
@Data
public class MeetType {
    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 会议类型
     */
    private String name;

    /**
     * 逻辑删除，0-否(默认)，1-是
     */
    @TableLogic(delval = "1", value = "0")
    private Integer isDel;

    /**
     * 允许自定义模板权限标识，0-不允许, 1-允许(默认)
     */
    private Integer personalPermission;

    /**
     * 此类型所有模板自动授权给。0-不授权，1-授权给所有人(默认)，2-自定义
     */
    private Integer authType;

    /**
     * 参考模板类型id
     */
    private Long relId;

    /**
     * 类型描述（用于让大模型筛选会议类型的提示词）
     */
    private String content;
    private String regex;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;

    /**
     * 
     */
    private String createUser;

    /**
     * 
     */
    private String updateUser;
    /**
     *
     */
    private String createUserName;

    /**
     *
     */
    private String updateUserName;
}