package com.cmeeting.mapper.primary;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.cmeeting.ad.entity.SysDept;
import com.cmeeting.ad.entity.SysUserSync;
import com.cmeeting.dto.PermissionCheckedDTO;
import com.cmeeting.dto.SysUserSyncDTO;
import com.cmeeting.dto.UserDTO;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface SysUserSyncMapper extends BaseMapper<SysUserSync> {

    String getParentDeptId(@Param(value = "deptId")String deptId);

    List<UserDTO> getUserEmail();

    List<SysUserSync> getSimpleUserList();

    List<SysDept> getSimpleDeptList();

    List<String> getSubDeptId(@Param(value = "deptId")String deptId);

    List<String> getUsersByDept(@Param(value = "deptIds") List<String> deptIds);

    List<PermissionCheckedDTO.User> findName(@Param("deptIds") List<String> deptIds, @Param("categoryId") String categoryId, @Param("search") String search,
                                             @Param("userList") List<String> userList);

    List<PermissionCheckedDTO.User> findInUserIdsOrShareCateIds(@Param("userIds") List<String> userIds, @Param("shareCateIds") List<String> shareCateIds,
                                                                @Param("search") String search);

    List<PermissionCheckedDTO.User> findByParam(@Param("userIds") List<String> userIds, @Param("notInCateIds") List<String> notInCateIds, @Param("cateIds") List<String> shareCateIds,
                                                @Param("search") String search, @Param("categoryId") String categoryId);

    Page<SysUserSyncDTO> selectByDeptId(@Param("deptIds") List<String> deptIds,
                                        @Param("page") Page page, @Param("search") String search);

    /**
     * 获取用户信息
     *
     * @param searchValue
     * @param userIdList
     * @return
     */
    @MapKey("userId")
    List<Map<String, String>> selectParamByUserIdList(@Param("searchValue") String searchValue,
                                                      @Param("userIdList") List<String> userIdList);


    List<SysUserSync> listByUserIds(@Param("ids") List<String> userIdList, @Param("search") String search);
}
