package com.cmeeting.log.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 纪要生成周期流程日志
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("log_process_log")
public class ProcessLog implements Serializable {

    private static final long serialVersionUID = -26238487532381000L;
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 会议ID（字符串类型）
     */
    private String meetingId;

    /**
     * 子会议ID
     */
    private String subMeetingId;

    /**
     * 消息
     */
    private String message;

    /**
     * 处理时间
     */
    private LocalDateTime operateTime;
}