package com.cmeeting.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 中集岗位标准信息(CimcPost)实体类
 *
 * @author makejava
 * @since 2023-11-11 17:06:41
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CimcPost implements Serializable {
    private static final long serialVersionUID = -26027491730988650L;
    
    private String id;
    /**
    * 岗位id
    */
    private String positionId;
    /**
    * 岗位名称
    */
    private String positionName;
    /**
    * 上级岗位id
    */
    private String responseToId;
    /**
    * 公司id
    */
    private String companyId;
    /**
    * 公司名称
    */
    private String companyName;
    /**
    * 组织id
    */
    private String unitId;
    /**
    * 组织名称
    */
    private String unitName;
    /**
    * 岗位描述
    */
    private Object positionDescription;
    /**
    * 定编人数
    */
    private String plannedHolderNum;
    /**
    * 在编人数
    */
    private String currentHolderNum;
    /**
    * 岗位编制性质
    */
    private String positionType;
    /**
    * 职族
    */
    private String zhizuId;
    /**
    * 职类
    */
    private String zhileiId;
    /**
    * 职层
    */
    private String zhicengId;
    /**
    * 集团职能
    */
    private String zhinengId;
    /**
    * 集团工种
    */
    private String gongzhongId;
    /**
    * 板块职能
    */
    private String bkZhinengId;
    /**
    * 板块工种
    */
    private String bkGongzhongId;
    /**
    * 创建者id
    */
    private String createdBy;
    /**
    * 创建日期
    */
    private Date creationDate;
    /**
    * 最后修改者
    */
    private String lastUpdatedBy;
    /**
    * 最后修改日期
    */
    private Date lastUpdateDate;

}
